MAP = DensityMaps{12,16};                                                 % choose the density map

GoalRegister = int8(zeros(200, 200));                                     % setting the variable for the target position
GoalRegister(170,170) = 1;                                                % enter the target location (x and y should be swapped here)


optimal_path = A_star(1,1 , MAP, GoalRegister, 10);


%% A_Star algorithm


function OptimalPath = A_star(StartX, StartY, MAP, GoalRegister, Connecting_Distance)

% FINDING A_STAR PATH IN A WEIGHTED GRID without obstacles (based on distance and population density)

%Generating goal nodes, which is represented by a matrix. Several goals can be speciefied, in which case the pathfinder will find the closest goal.
%a cell with the value 1 represent a goal cell

%Number of Neighboors one wants to investigate from each cell. A larger
%number of nodes means that the path can be alligned in more directions.

% Preallocation of Matrices
[Height, Width] = size(MAP); % Height and width of matrix
GScore = zeros(Height, Width);           % Matrix keeping track of G-scores
FScore = single(inf(Height, Width));     % Matrix keeping track of F-scores (only open list)
Hn = single(zeros(Height, Width));       % Heuristic matrix
OpenMAT = int8(zeros(Height, Width));    % Matrix keeping of open grid cells
ClosedMAT = int8(zeros(Height, Width));  % Matrix keeping track of closed grid cells
ParentX = int16(zeros(Height, Width));   % Matrix keeping track of X position of parent
ParentY = int16(zeros(Height, Width));   % Matrix keeping track of Y position of parent

%%% Setting up matrices representing neighbours to be investigated
NeighbourCheck = ones(2 * Connecting_Distance + 1);
Dummy = 2 * Connecting_Distance + 2;
Mid = Connecting_Distance + 1;
for i = 1:Connecting_Distance - 1
    NeighbourCheck(i, i) = 0;
    NeighbourCheck(Dummy - i, i) = 0;
    NeighbourCheck(i, Dummy - i) = 0;
    NeighbourCheck(Dummy - i, Dummy - i) = 0;
    NeighbourCheck(Mid, i) = 0;
    NeighbourCheck(Mid, Dummy - i) = 0;
    NeighbourCheck(i, Mid) = 0;
    NeighbourCheck(Dummy - i, Mid) = 0;
end
NeighbourCheck(Mid, Mid) = 0;
[row, col] = find(NeighbourCheck == 1);
Neighbours = [row col] - (Connecting_Distance + 1);
N_Neighbours = size(col, 1);
%%% End of setting up matrices representing neighbours to be investigated

%%%%%%%%% Creating Heuristic-matrix based on value of each node
for k = 1:size(GoalRegister, 1)
    for j = 1:size(GoalRegister, 2)
        if MAP(k, j) > 0  % Check if the node value is greater than 0
            % Heuristic is the density value of the node and distance to target
            % distance_to_goal = sqrt((StartX - j)^2 + (StartY - k)^2);
            % Hn(k, j) = 0.7*MAP(k, j) + 0.3*distance_to_goal;
             distance_to_goal = (sqrt((StartX - j)^2 + (StartY - k)^2)) / norm([200,200]);
            Hn(k, j) = 0.6*MAP(k, j) + 0.4*distance_to_goal;
        end
    end
end
% End of creating Heuristic-matrix.

% Initialising start node with FValue and opening first node.
FScore(StartY, StartX) = Hn(StartY, StartX);
OpenMAT(StartY, StartX) = 1;

while true % Code will break when path found or when no path exists
    MINopenFSCORE = min(min(FScore));
    if MINopenFSCORE == inf
        % Failure!
        OptimalPath = inf;
        RECONSTRUCTPATH = 0;
        break
    end
    [CurrentY, CurrentX] = find(FScore == MINopenFSCORE, 1, 'first');

    if GoalRegister(CurrentY, CurrentX) == 1
        % Goal reached!
        RECONSTRUCTPATH = 1;
        break
    end

    % Removing node from OpenList to ClosedList
    OpenMAT(CurrentY, CurrentX) = 0;
    FScore(CurrentY, CurrentX) = inf;
    ClosedMAT(CurrentY, CurrentX) = 1;

    for p = 1:N_Neighbours
        i = Neighbours(p, 1); % Y
        j = Neighbours(p, 2); % X
        if CurrentY + i < 1 || CurrentY + i > Height || CurrentX + j < 1 || CurrentX + j > Width
            continue
        end

        if ClosedMAT(CurrentY + i, CurrentX + j) == 0 % Neighbour is open
            % Calculate the tentative gScore based on the Euclidean distance and population density
            % tentative_gScore = GScore(CurrentY, CurrentX) + 0.3*sqrt(i^2 + j^2) + 0.7*MAP(CurrentY + i, CurrentX + j);
             tentative_gScore = GScore(CurrentY, CurrentX) + 0.4*(sqrt(i^2 + j^2))/(norm([200,200])) + 0.6*MAP(CurrentY + i, CurrentX + j);
            
            if tentative_gScore < GScore(CurrentY + i, CurrentX + j) || OpenMAT(CurrentY + i, CurrentX + j) == 0
                ParentX(CurrentY + i, CurrentX + j) = CurrentX;
                ParentY(CurrentY + i, CurrentX + j) = CurrentY;
                GScore(CurrentY + i, CurrentX + j) = tentative_gScore;
                FScore(CurrentY + i, CurrentX + j) = tentative_gScore + Hn(CurrentY + i, CurrentX + j);
                OpenMAT(CurrentY + i, CurrentX + j) = 1;
            end
        end
    end
end

k = 2;
if RECONSTRUCTPATH
    OptimalPath(1, :) = [CurrentY CurrentX];
    while RECONSTRUCTPATH
        CurrentXDummy = ParentX(CurrentY, CurrentX);
        CurrentY = ParentY(CurrentY, CurrentX);
        CurrentX = CurrentXDummy;
        OptimalPath(k, :) = [CurrentY CurrentX];
        k = k + 1;
        if CurrentX == StartX && CurrentY == StartY
            break
        end
    end
end


% Visualize the map and the optimal path
figure;
imagesc(MAP);
% colormap(flipud(gray));
colormap("parula");
hold on;
set(gca, 'YDir', 'normal');
colorbar;

plot(OptimalPath(:, 2), OptimalPath(:, 1), 'r', 'LineWidth', 2);

% Plot the start and target points
plot(StartX, StartY, 'go', 'MarkerSize', 10, 'MarkerFaceColor', 'g');  % Start point
[row, col] = find(GoalRegister); % find the location of target
plot(col, row, 'bo', 'MarkerSize', 10, 'MarkerFaceColor', 'b');  % Target point


end
